/*
 * Decompiled with CFR 0.152.
 */
package filenet.vw.api;

import filenet.vw.api.IVWHasWSParameterDefs;
import filenet.vw.api.VWActionType;
import filenet.vw.api.VWArrayHandler;
import filenet.vw.api.VWCompoundStepDefinition;
import filenet.vw.api.VWException;
import filenet.vw.api.VWFieldType;
import filenet.vw.api.VWInstructionDefinition;
import filenet.vw.api.VWMapDefinition;
import filenet.vw.api.VWSession;
import filenet.vw.api.VWValidationContext;
import filenet.vw.api.VWValidationError;
import filenet.vw.api.VWWebServiceParameterDefinition;
import filenet.vw.api.VWWorkflowSignature;
import filenet.vw.api.VWXMLHandler;
import filenet.vw.base.VWString;
import filenet.vw.base.exprcomp.VWCompiledExpr;
import filenet.vw.base.exprcomp.VWCompiledRefExpr;
import filenet.vw.base.exprcomp.VWExpr;
import java.io.Serializable;
import java.util.Vector;

public class VWReceiveInstruction
extends VWInstructionDefinition
implements Serializable,
IVWHasWSParameterDefs {
    private static final long serialVersionUID = 7510L;
    private String m_PartnerLinkName = null;
    private String m_OperationName = null;
    private String m_MessageExpr = null;
    private String m_MessageFromSchemaName = null;
    private String m_MessageFromElementName = null;
    private VWWebServiceParameterDefinition[] m_Parameters = null;
    private VWArrayHandler m_ParametersHandler = new VWArrayHandler();
    private String m_TimeoutExpr = null;
    private String m_TimeoutMap = null;
    private boolean m_Authentication = false;
    private String m_CorrelationSetName = null;
    private String[][] m_CorrelationSetProperties = null;
    private int m_OnlineID = -1;
    private int m_CorrelationParameterSeqNumber = -1;
    private String m_CorrelationValueExpression = null;
    private String[] m_SecurityGroup = null;

    public static String _get_FILE_DATE() {
        return "$Date: 2010-10-01 17:27:51 GMT $";
    }

    public static String _get_FILE_AUTHOR() {
        return "$Author: Kevin Bentley;096657649;kbentley@us.ibm.com (kbentley) $";
    }

    public static String _get_FILE_REVISION() {
        return "$Revision: /main/PUI_452_Int/PUI_460_Int/8 $";
    }

    protected VWReceiveInstruction(VWCompoundStepDefinition CompStep, int theInstructionId) throws VWException {
        super(CompStep, theInstructionId, 40);
    }

    protected VWReceiveInstruction(VWCompoundStepDefinition CompStep, int theInstructionId, String thePartnerLinkName, String theOperationName) throws VWException {
        super(CompStep, theInstructionId, 40);
        this.setPartnerLinkName(thePartnerLinkName);
        this.setOperationName(theOperationName);
    }

    public void setTimeoutExpr(String theTimeoutExpr) throws VWException {
        this.m_TimeoutExpr = theTimeoutExpr;
    }

    public String getTimeoutExpr() {
        return this.m_TimeoutExpr;
    }

    public void setTimeoutMapName(String theTimeoutMapName) throws VWException {
        this.m_TimeoutMap = theTimeoutMapName;
    }

    public String getTimeoutMapName() {
        return this.m_TimeoutMap;
    }

    public void setMessageExpr(String theMsgExpr) throws VWException {
        this.m_MessageExpr = theMsgExpr;
    }

    public String getMessageExpr() {
        return this.m_MessageExpr;
    }

    public void setPartnerLinkName(String thePartnerLinkName) throws VWException {
        if (thePartnerLinkName != null && thePartnerLinkName.length() > 0) {
            if (this.getStep().getMap() != null) {
                if (this.m_PartnerLinkName != null && this.m_PartnerLinkName.length() > 0 && this.getStep().getMap().getWorkflow().isExistingPartnerLinkName(this.m_PartnerLinkName)) {
                    this.getStep().getMap().getWorkflow().getPartnerLink(this.m_PartnerLinkName).removeReceiveStepRef(this);
                }
                if (this.getStep().getMap().getWorkflow().isExistingPartnerLinkName(thePartnerLinkName)) {
                    this.getStep().getMap().getWorkflow().getPartnerLink(thePartnerLinkName).addReceiveStepRef(this);
                }
            }
        } else if (this.m_PartnerLinkName != null && this.m_PartnerLinkName.length() > 0 && this.getStep().getMap().getWorkflow().isExistingPartnerLinkName(this.m_PartnerLinkName)) {
            this.getStep().getMap().getWorkflow().getPartnerLink(this.m_PartnerLinkName).removeReceiveStepRef(this);
        }
        this.m_PartnerLinkName = thePartnerLinkName;
    }

    public String getPartnerLinkName() {
        return this.m_PartnerLinkName;
    }

    public void setOperationName(String theOperationName) throws VWException {
        this.m_OperationName = theOperationName;
    }

    public String getOperationName() {
        return this.m_OperationName;
    }

    public VWWebServiceParameterDefinition createParameter(String theName, String theValue, int theType, boolean theIsArray) throws VWException {
        VWWebServiceParameterDefinition newParameter = new VWWebServiceParameterDefinition(this, theName, 2, theType, theIsArray, theValue);
        this.m_Parameters = (VWWebServiceParameterDefinition[])this.m_ParametersHandler.addElementToArray(this.m_Parameters, newParameter);
        return newParameter;
    }

    public void deleteParameter(int theSequenceNumber) throws VWException {
        int index = this.m_ParametersHandler.getIndexFromIntFieldValue(this.m_Parameters, "m_Sequence", theSequenceNumber);
        if (index == -1) {
            throw new VWException("vw.api.VWReceiveInstructionParameterNotFound", "No parameter found with sequence number equal to {0} in receive instruction.", String.valueOf(theSequenceNumber));
        }
        this.m_ParametersHandler.deleteElementFromArray(this.m_Parameters, index);
    }

    public void deleteAllParameters() throws VWException {
        this.m_ParametersHandler = new VWArrayHandler();
        this.m_Parameters = null;
    }

    public VWWebServiceParameterDefinition getParameterDefinition(int theSequenceNumber) throws VWException {
        int index = this.m_ParametersHandler.getIndexFromIntFieldValue(this.m_Parameters, "m_Sequence", theSequenceNumber);
        if (index == -1) {
            throw new VWException("vw.api.VWReceiveInstructionParameterNotFound", "No parameter found with sequence number equal to {0} in receive instruction.", String.valueOf(theSequenceNumber));
        }
        return this.m_Parameters[index];
    }

    public VWWebServiceParameterDefinition[] getParameterDefinitions() throws VWException {
        return (VWWebServiceParameterDefinition[])this.m_ParametersHandler.getElements(this.m_Parameters);
    }

    public String toString() {
        String retVal = "";
        try {
            retVal = VWActionType.typeToString(this.action);
        }
        catch (Exception exception) {
            // empty catch block
        }
        return retVal;
    }

    public void validate(VWSession theSession, Vector EDefVector, VWCompoundStepDefinition myStep) throws VWException {
        VWValidationContext validationContext = new VWValidationContext(theSession, EDefVector);
        this.validate(validationContext, myStep);
    }

    protected void validate(VWValidationContext validationContext, VWCompoundStepDefinition myStep) throws VWException {
        String[] launchResponses;
        block62: {
            VWValidationError theError;
            VWValidationError theError2;
            VWString theMessage;
            int i;
            int errorCount;
            String[] theErrorStrings;
            VWCompiledExpr compRes;
            VWWorkflowSignature myBaseWflSignature;
            VWWorkflowSignature myWflSignature;
            block61: {
                VWValidationError theError3;
                VWString theMessage2;
                myWflSignature = this.getStep().getMap().getWorkflow().getWorkflowSignature(validationContext);
                myBaseWflSignature = this.getStep().getMap().getWorkflow().getBaseWorkflowSignature(validationContext);
                if (this.m_PartnerLinkName == null || !myStep.getMap().getWorkflow().isExistingPartnerLinkName(this.m_PartnerLinkName) && (myBaseWflSignature == null || !myBaseWflSignature.isPartnerlinkName(this.m_PartnerLinkName))) {
                    theMessage2 = new VWString("vw.api.VWReceiveInstructionBadPartnerLinkName", "Partner link name, \"{0}\", is not the name of a partner link in this workflow definition.", this.m_PartnerLinkName);
                    theError3 = new VWValidationError(7, 1, myStep.getName(), VWActionType.typeToString(this.action), theMessage2.toString(), myStep.getMap().getName(), myStep.getStepId(), this.instructionId);
                    validationContext.addValidationError(theError3);
                }
                if (this.m_OperationName == null || this.m_OperationName.length() == 0) {
                    theMessage2 = new VWString("vw.api.VWReceiveInstructionNoOperationName", "The operation name is null or empty.");
                    theError3 = new VWValidationError(7, 1, myStep.getName(), VWActionType.typeToString(this.action), theMessage2.toString(), myStep.getMap().getName(), myStep.getStepId(), this.instructionId);
                    validationContext.addValidationError(theError3);
                }
                if (this.m_MessageExpr != null) {
                    compRes = new VWCompiledRefExpr();
                    theErrorStrings = VWExpr.compileVWExpr(this.m_MessageExpr, myWflSignature, myBaseWflSignature, null, null, true, compRes);
                    if (theErrorStrings != null) {
                        errorCount = theErrorStrings.length;
                        for (i = 0; i < errorCount; ++i) {
                            theMessage = new VWString("vw.api.VWReceiveInstructionSyntaxErrorInMessageExpr", "Syntax error in message expression of receive instruction (expected string expression, left hand value, i.e. it must be assignable) : {0}", theErrorStrings[i]);
                            theError2 = new VWValidationError(7, 1, myStep.getName(), this.m_MessageExpr, theMessage.toString(), myStep.getMap().getName(), myStep.getStepId(), this.instructionId);
                            validationContext.addValidationError(theError2);
                        }
                    } else if (compRes.getResultIsArray() || compRes.getResultType() != 2 && compRes.getResultType() != 128) {
                        VWString theMessage3 = new VWString("vw.api.VWReceiveInstructionMessageNotString", "Message expression must be an string expression, found a {0}.", VWFieldType.typeToString(compRes.getResultType()) + (compRes.getResultIsArray() ? "[ ]" : ""));
                        VWValidationError theError4 = new VWValidationError(7, 1, myStep.getName(), this.m_MessageExpr, theMessage3.toString(), myStep.getMap().getName(), myStep.getStepId(), this.instructionId);
                        validationContext.addValidationError(theError4);
                    }
                }
                if (this.m_TimeoutExpr != null && this.m_TimeoutExpr.compareTo("") == 0) {
                    theMessage2 = new VWString("vw.api.VWReceiveInstructionTimeOutIsNull", "Time Out value is empty, it must be null or a valid time expression");
                    theError3 = new VWValidationError(7, 1, myStep.getName(), VWActionType.typeToString(this.action), theMessage2.toString(), myStep.getMap().getName(), myStep.getStepId(), this.instructionId);
                    validationContext.addValidationError(theError3);
                }
                if (this.m_TimeoutExpr != null && this.m_TimeoutExpr.compareTo("") != 0 && (this.m_TimeoutMap == null || this.m_TimeoutMap.compareTo("") == 0)) {
                    theMessage2 = new VWString("vw.api.VWReceiveInstructionTimeOutExprButNoTimeOutMap", "Time out expression is set, but the time out map is set to none.  If either time out expression or time out map is set, then both must must be set to valid values.");
                    theError3 = new VWValidationError(7, 1, myStep.getName(), VWActionType.typeToString(this.action), theMessage2.toString(), myStep.getMap().getName(), myStep.getStepId(), this.instructionId);
                    validationContext.addValidationError(theError3);
                }
                if (this.m_TimeoutMap != null && this.m_TimeoutMap.compareTo("") != 0 && (this.m_TimeoutExpr == null || this.m_TimeoutExpr.compareTo("") == 0)) {
                    theMessage2 = new VWString("vw.api.VWReceiveInstructionTimeOutMapButNoTimeOutExpr", "Time out map is set, but the time out expression is set to none.  If either time out expression or time out map is set, then both must must be set to valid values.");
                    theError3 = new VWValidationError(7, 1, myStep.getName(), VWActionType.typeToString(this.action), theMessage2.toString(), myStep.getMap().getName(), myStep.getStepId(), this.instructionId);
                    validationContext.addValidationError(theError3);
                }
                if (this.m_TimeoutMap != null && VWMapDefinition.mapNameToId(this.m_TimeoutMap) == 0) {
                    try {
                        myStep.getMap().getWorkflow().getMap(this.m_TimeoutMap);
                    }
                    catch (Exception e) {
                        if (myBaseWflSignature != null && myBaseWflSignature.isInstructionSheetName(this.m_TimeoutMap)) break block61;
                        VWString theMessage4 = new VWString("vw.api.VWReceiveInstructionTimeoutMapNotFound", "The timeout map map, {0}, was not found in this workflow definition.", this.m_TimeoutMap);
                        VWValidationError theError5 = new VWValidationError(7, 1, myStep.getName(), this.m_TimeoutMap, theMessage4.toString(), myStep.getMap().getName(), myStep.getStepId(), this.getInstructionId());
                        validationContext.addValidationError(theError5);
                    }
                }
            }
            if (this.m_TimeoutExpr != null && this.m_TimeoutExpr.compareTo("") != 0 && this.m_TimeoutExpr.trim().compareTo("0") != 0) {
                compRes = new VWCompiledExpr();
                theErrorStrings = VWExpr.compileVWExpr(this.m_TimeoutExpr, myWflSignature, myBaseWflSignature, null, null, true, compRes);
                errorCount = 0;
                if (theErrorStrings != null) {
                    errorCount = theErrorStrings.length;
                    for (i = 0; i < errorCount; ++i) {
                        theMessage = new VWString("vw.api.VWReceiveInstructionTimeOutSyntaxError", "Time Out value: {0}", theErrorStrings[i]);
                        theError2 = new VWValidationError(7, 1, myStep.getName(), VWActionType.typeToString(this.action), theMessage.toString(), myStep.getMap().getName(), myStep.getStepId(), this.instructionId);
                        validationContext.addValidationError(theError2);
                    }
                } else if (compRes.getResultIsArray() || compRes.getResultType() != 16) {
                    VWString theMessage5 = new VWString("vw.api.VWWFEInstructionTimeOutNotTime", "Time Out value expression must be a time expression, found a {0}{1}.", VWFieldType.typeToString(compRes.getResultType()), compRes.getResultIsArray() ? "[ ]" : "");
                    theError = new VWValidationError(7, 1, myStep.getName(), VWActionType.typeToString(this.action), theMessage5.toString(), myStep.getMap().getName(), myStep.getStepId(), this.instructionId);
                    validationContext.addValidationError(theError);
                }
            }
            boolean atLeastOneAttachmentParamByValue = false;
            VWWebServiceParameterDefinition[] p = this.getParameterDefinitions();
            if (p != null) {
                for (int i2 = 0; i2 < p.length; ++i2) {
                    p[i2].validate(validationContext, myStep);
                    if (p[i2].isAttachmentByValue()) {
                        atLeastOneAttachmentParamByValue = true;
                    }
                    if (VWFieldType.isValidWebServiceParamName(p[i2].getName())) continue;
                    VWString theMessage6 = new VWString("vw.api.VWReceiveInstructionParamInValidWebServiceParamName", "Receive instruction parameter named \"{0}\" contains space(s) or colon(s).", p[i2].getName());
                    theError = new VWValidationError(7, 1, myStep.getName(), VWActionType.typeToString(this.action), theMessage6.toString(), myStep.getMap().getName(), myStep.getStepId(), this.instructionId);
                    validationContext.addValidationError(theError);
                }
            }
            if (atLeastOneAttachmentParamByValue && myStep.getMap().getWorkflow().getIncomingWSAttachmentFolder() == null) {
                VWString theMessage7 = new VWString("vw.api.VWReceiveInstructionIncomingAttachmentByValueNoIncomingAttachmentFolder", "At least one parameter in this receive instruction is an incoming attachment by value but there is no incoming attachment folder value set in the workflow.");
                VWValidationError theError6 = new VWValidationError(7, 1, myStep.getName(), VWActionType.typeToString(this.action), theMessage7.toString(), myStep.getMap().getName(), myStep.getStepId(), this.instructionId);
                validationContext.addValidationError(theError6);
            }
            if (this.m_CorrelationParameterSeqNumber != -1) {
                if (p == null || p.length == 0) {
                    VWString theMessage8 = new VWString("vw.api.VWReceiveInstructionCorrelationParameterSeqNumberButNoParameters", "Receive instruction Correlation parameter Sequence Number is set to  ({0}), but the receive instrucion contains no parameters.", String.valueOf(this.m_CorrelationParameterSeqNumber));
                    VWValidationError theError7 = new VWValidationError(7, 1, myStep.getName(), VWActionType.typeToString(this.action), theMessage8.toString(), myStep.getMap().getName(), myStep.getStepId(), this.instructionId);
                    validationContext.addValidationError(theError7);
                } else {
                    try {
                        this.getParameterDefinition(this.m_CorrelationParameterSeqNumber);
                    }
                    catch (VWException e) {
                        VWString theMessage9 = new VWString("vw.api.VWReceiveInstructionCorrelationParameterSeqNumberNotFound", "Receive instruction Correlation parameter sequence number ({0}) is not the sequence number of a parameter in this receive instruction.", String.valueOf(this.m_CorrelationParameterSeqNumber));
                        theError = new VWValidationError(7, 1, myStep.getName(), VWActionType.typeToString(this.action), theMessage9.toString(), myStep.getMap().getName(), myStep.getStepId(), this.instructionId);
                        validationContext.addValidationError(theError);
                    }
                }
            }
            if (this.m_CorrelationValueExpression != null && this.m_CorrelationParameterSeqNumber == -1) {
                VWString theMessage10 = new VWString("vw.api.VWReceiveInstructionCorrValExprNotNullCorrParSeqIsMinusOne", "The correlation value expression is not set, but the correlation value expression has a non-null value.");
                VWValidationError theError8 = new VWValidationError(7, 1, myStep.getName(), VWActionType.typeToString(this.action), theMessage10.toString(), myStep.getMap().getName(), myStep.getStepId(), this.instructionId);
                validationContext.addValidationError(theError8);
            }
            if (this.m_CorrelationValueExpression != null && this.m_CorrelationParameterSeqNumber != -1) {
                if (p == null || p.length == 0) {
                    VWString theMessage11 = new VWString("vw.api.VWReceiveInstructionCorrelationExprValueButNoParameters", "Receive instruction Correlation value expression is not null ({0}), but the receive instrucion contains no parameters.", this.m_CorrelationValueExpression);
                    VWValidationError theError9 = new VWValidationError(7, 1, myStep.getName(), VWActionType.typeToString(this.action), theMessage11.toString(), myStep.getMap().getName(), myStep.getStepId(), this.instructionId);
                    validationContext.addValidationError(theError9);
                } else {
                    VWCompiledExpr compRes2 = new VWCompiledExpr();
                    String[] theErrorStrings2 = VWExpr.compileVWExpr(this.m_CorrelationValueExpression, myWflSignature, myBaseWflSignature, null, null, true, compRes2);
                    if (theErrorStrings2 != null) {
                        int errorCount2 = theErrorStrings2.length;
                        for (int i3 = 0; i3 < errorCount2; ++i3) {
                            VWString theMessage12 = new VWString("vw.api.VWReceiveInstructionSyntaxErrorInCorrelationValueExpr", "Syntax error in correlation value expression of receive instruction (expected string expression, right hand value) : {0}", theErrorStrings2[i3]);
                            VWValidationError theError10 = new VWValidationError(7, 1, myStep.getName(), this.m_MessageExpr, theMessage12.toString(), myStep.getMap().getName(), myStep.getStepId(), this.instructionId);
                            validationContext.addValidationError(theError10);
                        }
                    } else if (compRes2.getResultIsArray() || compRes2.getResultType() != 2 && compRes2.getResultType() != 128) {
                        theMessage = new VWString("vw.api.VWReceiveInstructionCorrelationValueNotString", "Correlation value expression must be a string expression, found a {0}.", VWFieldType.typeToString(compRes2.getResultType()) + (compRes2.getResultIsArray() ? "[ ]" : ""));
                        theError2 = new VWValidationError(7, 1, myStep.getName(), this.m_MessageExpr, theMessage.toString(), myStep.getMap().getName(), myStep.getStepId(), this.instructionId);
                        validationContext.addValidationError(theError2);
                    }
                }
            }
            if (p != null && p.length > 0 && (this.m_MessageExpr != null || this.m_MessageFromSchemaName != null || this.m_MessageFromElementName != null || this.m_CorrelationSetProperties != null || this.m_CorrelationSetName != null)) {
                VWString theMessage13 = new VWString("vw.api.VWReceiveInstructionInvalidParameterCombination", "Ambiguity, Receive instruction contains parameters, indicating basic mode, but one or more of the advance mode data members are not null.");
                VWValidationError theError11 = new VWValidationError(7, 1, myStep.getName(), VWActionType.typeToString(this.action), theMessage13.toString(), myStep.getMap().getName(), myStep.getStepId(), this.instructionId);
                validationContext.addValidationError(theError11);
            }
            if (this.m_MessageExpr != null && (this.m_MessageFromSchemaName == null || this.m_MessageFromSchemaName.length() == 0 || this.m_MessageFromElementName == null || this.m_MessageFromElementName.length() == 0)) {
                VWString theMessage14 = new VWString("vw.api.VWReceiveInstructionMessageButNoSchemaOrElementName", "Ambiguity, Receive instruction contains a non-null message expression, but the schema name and/or the element name are null or empty.");
                VWValidationError theError12 = new VWValidationError(7, 1, myStep.getName(), VWActionType.typeToString(this.action), theMessage14.toString(), myStep.getMap().getName(), myStep.getStepId(), this.instructionId);
                validationContext.addValidationError(theError12);
            }
            if (this.m_ParametersHandler.getElementCount() > 0 && this.m_CorrelationParameterSeqNumber != -1 && (this.m_CorrelationParameterSeqNumber < 0 || this.m_CorrelationParameterSeqNumber >= this.m_ParametersHandler.getElementCount())) {
                VWString theMessage15 = new VWString("vw.api.VWReceiveInstructionCorrParamSeqNumberOutOfRange", "Receive instruction correlation parameter sequence number is {0} which is outside the allowed range 0 to (number of parameters -1) (0-{1}).", String.valueOf(this.m_CorrelationParameterSeqNumber), String.valueOf(this.m_ParametersHandler.getElementCount() - 1));
                VWValidationError theError13 = new VWValidationError(7, 1, myStep.getName(), VWActionType.typeToString(this.action), theMessage15.toString(), myStep.getMap().getName(), myStep.getStepId(), this.instructionId);
                validationContext.addValidationError(theError13);
            }
            if (this.m_CorrelationParameterSeqNumber != -1) {
                try {
                    this.getParameterDefinition(this.m_CorrelationParameterSeqNumber);
                }
                catch (Exception e) {
                    VWString theMessage16 = new VWString("vw.api.VWReceiveInstructionCorrParamSeqNumberInvalid", "Receive instruction correlation parameter sequence number is {0} which is not the sequence number of a parameter in this receive instruction.", String.valueOf(this.m_CorrelationParameterSeqNumber));
                    VWValidationError theError14 = new VWValidationError(7, 1, myStep.getName(), VWActionType.typeToString(this.action), theMessage16.toString(), myStep.getMap().getName(), myStep.getStepId(), this.instructionId);
                    validationContext.addValidationError(theError14);
                }
            } else {
                if (this.m_CorrelationParameterSeqNumber != -1 && this.getParameterDefinition(this.m_CorrelationParameterSeqNumber).getIsArray()) {
                    VWString theMessage17 = new VWString("vw.api.VWReceiveInstructionCorrParamSeqNumberArrayNotAllowed", "Receive instruction correlation parameter sequence number identifies an array parameter {0}, but the correlation parameter must not be an array.", this.getParameterDefinition(this.m_CorrelationParameterSeqNumber).getName());
                    VWValidationError theError15 = new VWValidationError(7, 1, myStep.getName(), VWActionType.typeToString(this.action), theMessage17.toString(), myStep.getMap().getName(), myStep.getStepId(), this.instructionId);
                    validationContext.addValidationError(theError15);
                }
                if (this.m_CorrelationParameterSeqNumber != -1 && this.getParameterDefinition(this.m_CorrelationParameterSeqNumber).getValue() == null) {
                    VWString theMessage18 = new VWString("vw.api.VWReceiveInstructionCorrParamSeqNumberArrayNotAllowed", "Receive instruction correlation parameter sequence number identifies a parameter, {0}, whose value is null, but the correlation parameter must have a non-null value.", this.getParameterDefinition(this.m_CorrelationParameterSeqNumber).getName());
                    VWValidationError theError16 = new VWValidationError(7, 1, myStep.getName(), VWActionType.typeToString(this.action), theMessage18.toString(), myStep.getMap().getName(), myStep.getStepId(), this.instructionId);
                    validationContext.addValidationError(theError16);
                }
            }
            if (p != null) {
                int i4;
                boolean[] seqNumFound = new boolean[p.length];
                for (i4 = 0; i4 < p.length; ++i4) {
                    if (p[i4].getSequenceNumber() < 0 || p[i4].getSequenceNumber() >= p.length) {
                        VWString theMessage19 = new VWString("vw.api.VWReceiveInstructionParamSeqNumberOutOfRange", "Receive instruction parameter named {0} has sequence number {1}, which outside the range 0-{2}.", p[i4].getName(), String.valueOf(p[i4].getSequenceNumber()), String.valueOf(p.length));
                        VWValidationError theError17 = new VWValidationError(7, 1, myStep.getName(), VWActionType.typeToString(this.action), theMessage19.toString(), myStep.getMap().getName(), myStep.getStepId(), this.instructionId);
                        validationContext.addValidationError(theError17);
                        continue;
                    }
                    if (seqNumFound[p[i4].getSequenceNumber()]) {
                        VWString theMessage20 = new VWString("vw.api.VWReceiveInstructionDuplicateSeqNumber", "Receive instruction parameter named {0} has sequence number {1}, which is already in use by parameter named {2} in this receive instruction.", p[i4].getName(), String.valueOf(p[i4].getSequenceNumber()), this.getParameterDefinition(i4).getName());
                        VWValidationError theError18 = new VWValidationError(7, 1, myStep.getName(), VWActionType.typeToString(this.action), theMessage20.toString(), myStep.getMap().getName(), myStep.getStepId(), this.instructionId);
                        validationContext.addValidationError(theError18);
                        continue;
                    }
                    seqNumFound[p[i4].getSequenceNumber()] = true;
                }
                for (i4 = 0; i4 < p.length; ++i4) {
                    seqNumFound[i4] = false;
                    if (!false) continue;
                    VWString theMessage21 = new VWString("vw.api.VWReceiveInstructionGapInSeqNumbers", "Receive instruction sequence number {0}, should occur in the parameters of this receive instruction but no parameter was found with that sequence number.", String.valueOf(i4));
                    VWValidationError theError19 = new VWValidationError(7, 1, myStep.getName(), VWActionType.typeToString(this.action), theMessage21.toString(), myStep.getMap().getName(), myStep.getStepId(), this.instructionId);
                    validationContext.addValidationError(theError19);
                }
            }
            if (p != null && p.length != 0) {
                if (p[0].getLexicalLevel() != 0 && p[0].getLexicalLevel() != 1) {
                    VWWebServiceParameterDefinition pDef = null;
                    try {
                        pDef = this.getParameterDefinition(0);
                    }
                    catch (Exception e) {
                        // empty catch block
                    }
                    VWString theMessage22 = new VWString("vw.api.VWReceiveInstructionParamSeqNumberZeroArrayNotLexLvlZero", "Receive instruction parameter named, {0}, with sequence number 0, must have lexical level 0 or 1, found lexical level {1}.", pDef != null ? pDef.getName() : "<< name not found - probably missing parameter with sequence number 0 >>", pDef != null ? String.valueOf(pDef.getLexicalLevel()) : "<unknown>");
                    VWValidationError theError20 = new VWValidationError(7, 1, myStep.getName(), VWActionType.typeToString(this.action), theMessage22.toString(), myStep.getMap().getName(), myStep.getStepId(), this.instructionId);
                    validationContext.addValidationError(theError20);
                } else {
                    for (int i5 = 1; i5 < p.length; ++i5) {
                        if (p[i5].getLexicalLevel() >= 0 && p[i5].getLexicalLevel() <= this.getParameterDefinition(p[i5].getSequenceNumber() - 1).getLexicalLevel() + 1) continue;
                        VWString theMessage23 = new VWString("vw.api.VWReceiveInstructionParamLexLvlInconsistency", "Receive instruction parameter named, {0}, has lexical level {1}, expected lexical level in the range 0 - {2}.", this.getParameterDefinition(i5).getName() + " (seq. # " + String.valueOf(this.getParameterDefinition(i5).getSequenceNumber()) + ") ", String.valueOf(this.getParameterDefinition(i5).getLexicalLevel()), String.valueOf(this.getParameterDefinition(p[i5].getSequenceNumber() - 1).getLexicalLevel() + 1));
                        VWValidationError theError21 = new VWValidationError(7, 1, myStep.getName(), VWActionType.typeToString(this.action), theMessage23.toString(), myStep.getMap().getName(), myStep.getStepId(), this.instructionId);
                        validationContext.addValidationError(theError21);
                    }
                }
            }
            if (!(p == null || this.isLaunchReceive() || this.m_CorrelationValueExpression != null && this.m_CorrelationValueExpression.length() != 0 && this.m_CorrelationParameterSeqNumber != -1)) {
                VWString theMessage24 = new VWString("vw.api.VWReceiveInstructionBasicNonLaunchReceiveMissingCorrelationDef", "Non-Launch Receive instruction using parameters (basic mode),  must have both Correlation Value Expression and Correlation Parameter Sequence Number.");
                VWValidationError theError22 = new VWValidationError(7, 1, myStep.getName(), VWActionType.typeToString(this.action), theMessage24.toString(), myStep.getMap().getName(), myStep.getStepId(), this.instructionId);
                validationContext.addValidationError(theError22);
            }
            if (!(this.m_MessageExpr == null || this.isLaunchReceive() || this.m_CorrelationSetName != null && this.m_CorrelationSetName.length() != 0 && this.m_CorrelationSetProperties != null)) {
                VWString theMessage25 = new VWString("vw.api.VWReceiveInstructionAdvancedNonLaunchReceiveMissingCorrelationDef", "Non-Launch Receive instruction using message (advanced mode),  must have both Correlation set name and Correlation set properties.");
                VWValidationError theError23 = new VWValidationError(7, 1, myStep.getName(), VWActionType.typeToString(this.action), theMessage25.toString(), myStep.getMap().getName(), myStep.getStepId(), this.instructionId);
                validationContext.addValidationError(theError23);
            }
            if (this.m_MessageFromSchemaName != null) {
                try {
                    myStep.getMap().getWorkflow().getSchema(this.m_MessageFromSchemaName);
                }
                catch (VWException e) {
                    if (myBaseWflSignature != null && myBaseWflSignature.isSchemaName(this.m_MessageFromSchemaName)) break block62;
                    VWString theMessage26 = new VWString("vw.api.VWReceiveInstructionBadSchema", "Receive instruction has a schema name, {0}, which is not the name of a schema defined in this workflow definition.", this.m_MessageFromSchemaName);
                    VWValidationError theError24 = new VWValidationError(7, 1, myStep.getName(), VWActionType.typeToString(this.action), theMessage26.toString(), myStep.getMap().getName(), myStep.getStepId(), this.instructionId);
                    validationContext.addValidationError(theError24);
                }
            }
        }
        if (this.isLaunchReceive() && (launchResponses = myStep.getMap().getWorkflow().getLaunchStep().getResponses()) != null && launchResponses.length > 0) {
            VWString theMessage = new VWString("vw.api.VWReceiveInstructionLaunchReceiveAndResponses", "The launch step in this workflow cannot have responses if the workflow contains any Launch Receive Instructions.  A Receive instruction is a Launch Receive Instruction if it is the first receive instruction in a system step which has a direct one hop route from the launch step.");
            VWValidationError theError = new VWValidationError(7, 1, myStep.getName(), VWActionType.typeToString(this.action), theMessage.toString(), myStep.getMap().getName(), myStep.getStepId(), this.instructionId);
            validationContext.addValidationError(theError);
        }
    }

    public void toXML(StringBuffer theBuffer) throws VWException {
        int i;
        String ATTRIB_INDENT = "\t\t\t\t";
        if (theBuffer == null) {
            throw new VWException("vw.api.VWReceiveInstructionNullBuffer", "buffer parameter cannot be null.");
        }
        theBuffer.append("\t\t\t<receive\n");
        theBuffer.append(ATTRIB_INDENT + "Id=\"" + Integer.toString(this.getInstructionId()) + "\"\n");
        theBuffer.append(ATTRIB_INDENT + "Action=\"" + VWActionType.typeToString(this.getAction()) + "\"\n");
        theBuffer.append(ATTRIB_INDENT + "partnerLink=\"" + VWXMLHandler.toXMLString(this.m_PartnerLinkName) + "\"\n");
        theBuffer.append(ATTRIB_INDENT + "operation=\"" + VWXMLHandler.toXMLString(this.m_OperationName) + "\"");
        if (this.m_MessageExpr != null) {
            theBuffer.append("\n" + ATTRIB_INDENT + "message=\"" + VWXMLHandler.toXMLString(this.m_MessageExpr) + "\"");
        }
        if (this.m_MessageFromSchemaName != null) {
            theBuffer.append("\n" + ATTRIB_INDENT + "messageFromSchema=\"" + VWXMLHandler.toXMLString(this.m_MessageFromSchemaName) + "\"");
        }
        if (this.m_MessageFromElementName != null) {
            theBuffer.append("\n" + ATTRIB_INDENT + "messageFromElement=\"" + VWXMLHandler.toXMLString(this.m_MessageFromElementName) + "\"");
        }
        if (this.m_TimeoutExpr != null) {
            theBuffer.append("\n" + ATTRIB_INDENT + "timeout=\"" + VWXMLHandler.toXMLString(this.m_TimeoutExpr) + "\"");
        }
        if (this.m_TimeoutMap != null) {
            theBuffer.append("\n" + ATTRIB_INDENT + "timeoutMap=\"" + VWXMLHandler.toXMLString(this.m_TimeoutMap) + "\"");
        }
        if (this.m_CorrelationValueExpression != null) {
            theBuffer.append("\n" + ATTRIB_INDENT + "correlationValueExpression=\"" + VWXMLHandler.toXMLString(this.m_CorrelationValueExpression) + "\"");
        }
        if (this.m_CorrelationParameterSeqNumber != -1) {
            theBuffer.append("\n" + ATTRIB_INDENT + "correlationParameterSequenceNumber=\"" + Integer.toString(this.m_CorrelationParameterSeqNumber) + "\"");
        }
        if (this.m_Authentication) {
            theBuffer.append("\n" + ATTRIB_INDENT + "authentication=\"true\"");
        }
        theBuffer.append(">\n");
        VWWebServiceParameterDefinition[] p = this.getParameterDefinitions();
        if (p != null) {
            for (i = 0; i < p.length; ++i) {
                p[i].toXML(theBuffer);
            }
        }
        if (this.m_CorrelationSetName != null) {
            theBuffer.append(ATTRIB_INDENT + "<correlationSet\n");
            ATTRIB_INDENT = ATTRIB_INDENT + "\t";
            theBuffer.append(ATTRIB_INDENT + "name=\"" + VWXMLHandler.toXMLString(this.m_CorrelationSetName) + "\">\n");
            if (this.m_CorrelationSetProperties != null) {
                for (i = 0; i < this.m_CorrelationSetProperties.length; ++i) {
                    theBuffer.append(ATTRIB_INDENT + "<property name=\"" + VWXMLHandler.toXMLString(this.m_CorrelationSetProperties[i][0]) + "\" query=\"" + VWXMLHandler.toXMLString(this.m_CorrelationSetProperties[i][1]) + "\" />\n");
                }
            }
            ATTRIB_INDENT = "\t\t\t\t";
            theBuffer.append(ATTRIB_INDENT + "</correlationSet>\n");
        }
        if (this.m_SecurityGroup != null && this.m_SecurityGroup.length > 0) {
            theBuffer.append(ATTRIB_INDENT + "<securityGroup>\n");
            for (i = 0; i < this.m_SecurityGroup.length; ++i) {
                theBuffer.append(ATTRIB_INDENT + "\t" + "<Expression Val=\"" + VWXMLHandler.toXMLString(this.m_SecurityGroup[i]) + "\" />\n");
            }
            theBuffer.append(ATTRIB_INDENT + "</securityGroup>\n");
        }
        theBuffer.append("\t\t\t</receive>\n");
    }

    public void toXPDL(String indentA, StringBuffer theBuffer) throws VWException {
        int i;
        String indentB = VWXMLHandler.incXMLIndent(indentA);
        String indentC = VWXMLHandler.incXMLIndent(indentB);
        String indentD = VWXMLHandler.incXMLIndent(indentC);
        if (theBuffer == null) {
            throw new VWException("vw.api.VWReceiveInstructionXPDLNullBuffer", "toXPDL buffer parameter cannot be null.");
        }
        theBuffer.append(indentA + "<TaskReceive Instantiate=\"false\" Implementation=\"WebService\">\n");
        VWWebServiceParameterDefinition[] parameters = this.getParameterDefinitions();
        if (parameters != null || this.m_MessageExpr != null || this.m_MessageFromSchemaName != null || this.m_MessageFromElementName != null) {
            theBuffer.append(indentB + "<Message Id=\"Incoming\">\n");
            theBuffer.append(indentC + "<ActualParameters>\n");
            if (parameters != null) {
                for (i = 0; i < parameters.length; ++i) {
                    parameters[i].toXPDL(indentD, theBuffer);
                }
            } else {
                if (this.m_MessageExpr != null) {
                    theBuffer.append(indentD + "<fn:ActualParameter fn:Source=\"Expression\">" + VWXMLHandler.toXMLString(this.m_MessageExpr) + "</fn:ActualParameter>\n");
                }
                if (this.m_MessageFromSchemaName != null) {
                    theBuffer.append(indentD + "<fn:ActualParameter fn:Source=\"Schema\">" + VWXMLHandler.toXMLString(this.m_MessageFromSchemaName) + "</fn:ActualParameter>\n");
                }
                if (this.m_MessageFromElementName != null) {
                    theBuffer.append(indentD + "<fn:ActualParameter fn:Source=\"Element\">" + VWXMLHandler.toXMLString(this.m_MessageFromElementName) + "</fn:ActualParameter>\n");
                }
            }
            theBuffer.append(indentC + "</ActualParameters>\n");
            theBuffer.append(indentB + "</Message>\n");
        } else {
            theBuffer.append(indentB + "<Message Id=\"Incoming\"/>\n");
        }
        theBuffer.append(indentB + "<WebServiceOperation OperationName=\"" + VWXMLHandler.toXMLString(this.m_OperationName) + "\">\n");
        theBuffer.append(indentC + "<Partner PartnerLinkId=\"" + VWXMLHandler.toXMLString(this.m_PartnerLinkName) + "\" RoleType=\"MyRole\"/>\n");
        theBuffer.append(indentB + "</WebServiceOperation>\n");
        theBuffer.append(indentB + "<fn:ReceiveParameters Id=\"" + Integer.toString(this.getInstructionId()) + "\"");
        if (this.m_TimeoutExpr != null) {
            theBuffer.append("\n" + indentC + "timeout=\"" + VWXMLHandler.toXMLString(this.m_TimeoutExpr) + "\"");
        }
        if (this.m_TimeoutMap != null) {
            theBuffer.append("\n" + indentC + "timeoutMap=\"" + VWXMLHandler.toXMLString(this.m_TimeoutMap) + "\"");
        }
        if (this.m_CorrelationValueExpression != null) {
            theBuffer.append("\n" + indentC + "correlationValueExpression=\"" + VWXMLHandler.toXMLString(this.m_CorrelationValueExpression) + "\"");
        }
        if (this.m_CorrelationParameterSeqNumber != -1) {
            theBuffer.append("\n" + indentC + "correlationParameterSequenceNumber=\"" + Integer.toString(this.m_CorrelationParameterSeqNumber) + "\"");
        }
        if (this.m_Authentication) {
            theBuffer.append("\n" + indentC + "authentication=\"true\"");
        }
        theBuffer.append(">\n");
        if (this.m_CorrelationSetName != null) {
            theBuffer.append(indentC + "<correlationSet name=\"" + VWXMLHandler.toXMLString(this.m_CorrelationSetName) + "\">\n");
            if (this.m_CorrelationSetProperties != null) {
                for (i = 0; i < this.m_CorrelationSetProperties.length; ++i) {
                    theBuffer.append(indentD + "<property name=\"" + VWXMLHandler.toXMLString(this.m_CorrelationSetProperties[i][0]) + "\"\n" + VWXMLHandler.incXMLIndent(indentD) + "query=\"" + VWXMLHandler.toXMLString(this.m_CorrelationSetProperties[i][1]) + "\"/>\n");
                }
            }
            theBuffer.append(indentC + "</correlationSet>\n");
        }
        if (this.m_SecurityGroup != null && this.m_SecurityGroup.length > 0) {
            theBuffer.append(indentC + "<securityGroup>\n");
            for (i = 0; i < this.m_SecurityGroup.length; ++i) {
                theBuffer.append(indentD + "<Expression Val=\"" + VWXMLHandler.toXMLString(this.m_SecurityGroup[i]) + "\" />\n");
            }
            theBuffer.append(indentC + "</securityGroup>\n");
        }
        theBuffer.append(indentB + "</fn:ReceiveParameters>\n");
        theBuffer.append(indentA + "</TaskReceive>\n");
    }

    public void setMessageFromSchemaName(String theSchema) throws VWException {
        this.m_MessageFromSchemaName = theSchema;
    }

    public String getMessageFromSchemaName() {
        return this.m_MessageFromSchemaName;
    }

    public void setMessageFromElementName(String theElement) throws VWException {
        this.m_MessageFromElementName = theElement;
    }

    public String getMessageFromElementName() {
        return this.m_MessageFromElementName;
    }

    public void setAuthentication(boolean theAuthenticationFlag) throws VWException {
        this.m_Authentication = theAuthenticationFlag;
    }

    public boolean getAuthentication() {
        return this.m_Authentication;
    }

    protected void setOnlineId(int theOnlineId) {
        this.m_OnlineID = theOnlineId;
    }

    public int getOnlineId() {
        return this.m_OnlineID;
    }

    public void setCorrelationSetName(String theName) throws VWException {
        int nMaxLength = 123;
        if (theName != null && theName.length() > nMaxLength) {
            throw new VWException("vw.api.VWReceiveInstructionCorrelationSetNameInvalidNameIsTooLong", "Setting correlation set name, theName is invalid because it contains more than {0} characters.", nMaxLength);
        }
        if (theName != null) {
            for (int i = 1; i < theName.length(); ++i) {
                char c = theName.charAt(i);
                if (Character.isLetterOrDigit(c) || c == '_') continue;
                throw new VWException("vw.api.VWReceiveInstructionCorrelationSetNameInvalidNameBadCharacter", "Setting correlation set name, theName is invalid because it contains an invalid character \"{0}\", the name can only contain letters, digits and underscore characters.", String.valueOf(c));
            }
        }
        this.m_CorrelationSetName = theName;
    }

    public String getCorrelationSetName() {
        return this.m_CorrelationSetName;
    }

    public void setCorrelationSetProperties(String[][] theProps) throws VWException {
        if (theProps != null) {
            for (int i = 0; i < theProps.length; ++i) {
                if (theProps[i].length != 2) {
                    throw new VWException("vw.api.VWCorrelationSetPropertyArrayWrongDimension", "Correlation set property array wrong dimension, row {0} has {1} elements, should have 2 (representing the property name and property query of the correlation set property)", String.valueOf(i), String.valueOf(theProps[i].length));
                }
                if (theProps[i][0] != null && theProps[i][1] != null) continue;
                throw new VWException("vw.api.VWCorrelationSetPropertyArrayNullElement", "Correlation set property array contains a null entry in row {0}", String.valueOf(i));
            }
        }
        this.m_CorrelationSetProperties = theProps;
    }

    public String[][] getCorrelationSetProperties() {
        return this.m_CorrelationSetProperties;
    }

    public void setCorrelationParameterSequenceNumber(int theParamSeqNumber) throws VWException {
        this.m_CorrelationParameterSeqNumber = theParamSeqNumber;
    }

    public int getCorrelationParameterSequenceNumber() {
        return this.m_CorrelationParameterSeqNumber;
    }

    public void setCorrelationValueExpression(String theValueExpr) throws VWException {
        this.m_CorrelationValueExpression = theValueExpr;
    }

    public String getCorrelationValueExpression() {
        return this.m_CorrelationValueExpression;
    }

    protected boolean isLaunchReceive() throws VWException {
        VWInstructionDefinition[] theInsts;
        if (this.getStep().getMap().getName().equals("Workflow") && this.getStep().getMap().getRouteBetween(0, this.getStep().getStepId()) != null && (theInsts = this.getStep().getInstructions()) != null) {
            for (int i = 0; i < theInsts.length; ++i) {
                if (theInsts[i] instanceof VWReceiveInstruction) {
                    if (theInsts[i].getInstructionId() != this.getInstructionId()) continue;
                    return true;
                }
                return false;
            }
        }
        return false;
    }

    public void setSecurityGroup(String[] theSecurityGroup) throws VWException {
        if (theSecurityGroup != null) {
            for (int i = 0; i < theSecurityGroup.length; ++i) {
                if (theSecurityGroup[i] != null && theSecurityGroup[i].length() != 0) continue;
                throw new VWException("vw.api.VWReceiveInstructionSecurityGroupHasNullOrEmptyElement", "Setting security group, security group contains a null or empty element at offset {0}.  Null or empty elements are not allowed in the security group array.", String.valueOf(i));
            }
        }
        this.m_SecurityGroup = theSecurityGroup;
    }

    public String[] getSecurityGroup() {
        return this.m_SecurityGroup;
    }

    protected void addMeToMyPartnerLinkReferences() throws VWException {
        if (this.getStep().getMap() != null && this.m_PartnerLinkName != null && this.m_PartnerLinkName.length() > 0 && this.getStep().getMap().getWorkflow().isExistingPartnerLinkName(this.m_PartnerLinkName)) {
            this.getStep().getMap().getWorkflow().getPartnerLink(this.m_PartnerLinkName).addReceiveStepRef(this);
        }
    }
}

